# Fine-grained Separation of Action-Background for Point-Level Temporal Action Localization
### Pytorch Implementation

![architecture](architecture.png)


## Prerequisites
### Recommended Environment
* Python 3.7.5
* joblib==0.13.0
* numpy==1.21.6
* pandas==1.3.5
* PyYAML==6.0
* PyYAML==6.0
* scipy==1.7.3
* tensorboard_logger==0.1.0
* torch==1.8.1+cu111
* tqdm==4.31.1

### Depencencies
You can set up the environments by using `$ pip install -r requirements.txt`.

### Data Preparation
1. Prepare [THUMOS'14](https://www.crcv.ucf.edu/THUMOS14/) dataset.

2. we provide extracted features from the link provided in [this repo](https://github.com/ispc-lab/ACM-Net/blob/main/README.md#motivation).
    
3. Place the features inside the `dataset` folder.
    - Please ensure the data structure is as below.

4. You can find these datasets (GTEA and BEOID) and labels in [this repo](https://bitbucket.org/dmoltisanti/action_recognition_single_timestamps/src) 

5. ActivityNet v1.3 can be acquired in [this repo](http://activity-net.org/) 
~~~~
├── dataset
   └── THUMOS14
       ├── gt.json
       ├── split_train.txt
       ├── split_test.txt
       ├── fps_dict.json
       ├── point_gaussian
           └── point_labels.csv
       └── features
           ├── train
               ├── rgb
                   ├── video_validation_0000051.npy
                   ├── video_validation_0000052.npy
                   └── ...
               └── flow
                   ├── video_validation_0000051.npy
                   ├── video_validation_0000052.npy
                   └── ...
           └── test
               ├── rgb
                   ├── video_test_0000004.npy
                   ├── video_test_0000006.npy
                   └── ...
               └── flow
                   ├── video_test_0000004.npy
                   ├── video_test_0000006.npy
                   └── ...
~~~~

## Usage

### Running
* You can easily train and evaluate the model by running the script below.
* You can switch the training configuration file by changing "config_path" of "run.sh".
~~~~
$ bash run.sh
~~~~

### Evaulation
* The pre-trained model can be found [here].
* You need to modify the correct path "model_file" of the evaluation configuration file.
* You can evaluate the model by running the command below.
* You can switch the evaluation configuration file by changing "config_path" of "run_eval.sh".
~~~~
$ bash run_eval.sh
~~~~
